/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.ShortFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class MinShortGroupByFunction
extends ShortFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public MinShortGroupByFunction(int position, @NotNull Function arg) {
        super(position);
        this.arg = arg;
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putShort(this.valueIndex, this.arg.getShort(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        short min = mapValue.getShort(this.valueIndex);
        short next = this.arg.getShort(record);
        if (next < min) {
            mapValue.putShort(this.valueIndex, next);
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(2);
    }

    @Override
    public void setShort(MapValue mapValue, short value) {
        mapValue.putShort(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putShort(this.valueIndex, (short)0);
    }

    @Override
    public short getShort(Record rec) {
        return rec.getShort(this.valueIndex);
    }
}

