/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.ByteFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class SumByteGroupByFunction
extends ByteFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public SumByteGroupByFunction(int position, @NotNull Function arg) {
        super(position);
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putByte(this.valueIndex, this.arg.getByte(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        mapValue.addByte(this.valueIndex, this.arg.getByte(record));
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(1);
    }

    @Override
    public void setByte(MapValue mapValue, byte value) {
        mapValue.putByte(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putByte(this.valueIndex, (byte)0);
    }

    @Override
    public byte getByte(Record rec) {
        return rec.getByte(this.valueIndex);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public boolean isConstant() {
        return false;
    }
}

