/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class SumDoubleGroupByFunction
extends DoubleFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public SumDoubleGroupByFunction(int position, @NotNull Function arg) {
        super(position);
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        double value = this.arg.getDouble(record);
        if (value == value) {
            mapValue.putDouble(this.valueIndex, value);
        } else {
            mapValue.putDouble(this.valueIndex, 0.0);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        double value = this.arg.getDouble(record);
        if (value == value) {
            mapValue.addDouble(this.valueIndex, value);
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(9);
    }

    @Override
    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
    }

    @Override
    public double getDouble(Record rec) {
        return rec.getDouble(this.valueIndex);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public boolean isConstant() {
        return false;
    }
}

