/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.ObjList;

public class LtDoubleCVFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<(dD)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        double left = args.getQuick(0).getDouble(null);
        if (Double.isNaN(left)) {
            return new BooleanConstant(position, false);
        }
        return new FuncCV(position, left, args.getQuick(1));
    }

    private static class FuncCV
    extends BooleanFunction
    implements UnaryFunction {
        private final double left;
        private final Function right;

        public FuncCV(int position, double left, Function right) {
            super(position);
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getArg() {
            return this.right;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.left < this.right.getDouble(rec);
        }
    }
}

