/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.ObjList;

public class LtDoubleVCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<(Dd)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        double right = args.getQuick(1).getDouble(null);
        if (Double.isNaN(right)) {
            return new BooleanConstant(position, false);
        }
        return new FuncVC(position, args.getQuick(0), right);
    }

    private static class FuncVC
    extends BooleanFunction
    implements UnaryFunction {
        private final Function left;
        private final double right;

        public FuncVC(int position, Function left, double right) {
            super(position);
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getArg() {
            return this.left;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.left.getDouble(rec) < this.right;
        }
    }
}

