/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.ObjList;

public class AbsIntFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "abs(I)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new AbsIntFunction(position, args.getQuick(0));
    }

    private static class AbsIntFunction
    extends IntFunction
    implements UnaryFunction {
        private final Function arg;

        public AbsIntFunction(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public int getInt(Record rec) {
            int value = this.arg.getInt(rec);
            return value < 0 ? -value : value;
        }
    }
}

