/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.std.ObjList;

public class AddFloatFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "+(FF)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new Func(position, args.getQuick(0), args.getQuick(1));
    }

    private static class Func
    extends FloatFunction
    implements BinaryFunction {
        final Function left;
        final Function right;

        public Func(int position, Function left, Function right) {
            super(position);
            this.left = left;
            this.right = right;
        }

        @Override
        public float getFloat(Record rec) {
            return this.left.getFloat(rec) + this.right.getFloat(rec);
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }
}

