/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.ObjList;

public class MulLongFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "*(LL)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new Func(position, args.getQuick(0), args.getQuick(1));
    }

    private static final class Func
    extends LongFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public Func(int position, Function left, Function right) {
            super(position);
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public long getLong(Record rec) {
            return this.left.getLong(rec) * this.right.getLong(rec);
        }
    }
}

