/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class RoundUpDoubleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "round_up(DI)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        Function scale = args.getQuick(1);
        if (scale.isConstant()) {
            int scaleValue = scale.getInt(null);
            if (scaleValue != Integer.MIN_VALUE) {
                if (scaleValue > -1 && scaleValue < Numbers.pow10max) {
                    return new FuncPosConst(position, args.getQuick(0), scaleValue);
                }
                if (scaleValue < 0 && scaleValue > -Numbers.pow10max) {
                    return new FuncNegConst(position, args.getQuick(0), -scaleValue);
                }
            }
            return new DoubleConstant(position, Double.NaN);
        }
        return new Func(position, args.getQuick(0), args.getQuick(1));
    }

    private static class Func
    extends DoubleFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public Func(int position, Function left, Function right) {
            super(position);
            this.left = left;
            this.right = right;
        }

        @Override
        public double getDouble(Record rec) {
            double l = this.left.getDouble(rec);
            if (l != l) {
                return l;
            }
            int r = this.right.getInt(rec);
            if (r == Integer.MIN_VALUE) {
                return Double.NaN;
            }
            try {
                return Numbers.roundUp(l, r);
            }
            catch (NumericException e) {
                return Double.NaN;
            }
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }

    private static class FuncNegConst
    extends DoubleFunction
    implements UnaryFunction {
        private final Function arg;
        private final int scale;

        public FuncNegConst(int position, Function arg, int r) {
            super(position);
            this.arg = arg;
            this.scale = r;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public double getDouble(Record rec) {
            double l = this.arg.getDouble(rec);
            if (l != l) {
                return l;
            }
            return Numbers.roundUpNegScale(l, this.scale);
        }
    }

    private static class FuncPosConst
    extends DoubleFunction
    implements UnaryFunction {
        private final Function arg;
        private final int scale;

        public FuncPosConst(int position, Function arg, int r) {
            super(position);
            this.arg = arg;
            this.scale = r;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public double getDouble(Record rec) {
            double l = this.arg.getDouble(rec);
            if (l != l) {
                return l;
            }
            return Numbers.roundUpPosScale(l, this.scale);
        }
    }
}

