/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.regex.impl.Matcher;
import io.questdb.griffin.engine.functions.regex.impl.Pattern;
import io.questdb.griffin.engine.functions.regex.impl.PatternSyntaxException;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;

public class MatchStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "~=(Ss)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        Function value = args.getQuick(0);
        CharSequence regex = args.getQuick(1).getStr(null);
        if (regex == null) {
            throw SqlException.$(args.getQuick(1).getPosition(), "NULL regex");
        }
        try {
            Matcher matcher = Pattern.compile(Chars.toString(regex)).matcher("");
            return new MatchFunction(position, value, matcher);
        }
        catch (PatternSyntaxException e) {
            throw SqlException.$(args.getQuick(1).getPosition() + e.getIndex() + 1, e.getMessage());
        }
    }

    private static class MatchFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Function value;
        private final Matcher matcher;

        public MatchFunction(int position, Function value, Matcher matcher) {
            super(position);
            this.value = value;
            this.matcher = matcher;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.getArg().getStr(rec);
            return cs != null && this.matcher.reset(cs).find();
        }

        @Override
        public Function getArg() {
            return this.value;
        }
    }
}

