/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.griffin.engine.functions.GenericRecordCursorFactory;
import io.questdb.std.ObjList;

public class LongSequenceFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;

    @Override
    public String getSignature() {
        return "long_sequence(l)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        long recordCount = args.getQuick(0).getLong(null);
        return new CursorFunction(position, new GenericRecordCursorFactory(METADATA, new LongSequenceRecordCursor(Math.max(0L, recordCount)), true));
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("x", 5));
        METADATA = metadata;
    }

    static class LongSequenceRecord
    implements Record {
        private long value;

        LongSequenceRecord() {
        }

        @Override
        public long getLong(int col) {
            return this.value;
        }

        @Override
        public long getRowId() {
            return this.value;
        }

        long getValue() {
            return this.value;
        }

        void next() {
            ++this.value;
        }

        void of(long value) {
            this.value = value;
        }
    }

    static class LongSequenceRecordCursor
    implements RecordCursor {
        private final long recordCount;
        private final LongSequenceRecord recordA = new LongSequenceRecord();
        private final LongSequenceRecord recordB = new LongSequenceRecord();

        public LongSequenceRecordCursor(long recordCount) {
            this.recordCount = recordCount;
            this.recordA.of(0L);
        }

        @Override
        public void close() {
        }

        @Override
        public long size() {
            return this.recordCount;
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public boolean hasNext() {
            if (this.recordA.getValue() < this.recordCount) {
                this.recordA.next();
                return true;
            }
            return false;
        }

        @Override
        public Record getRecordB() {
            return this.recordB;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            ((LongSequenceRecord)record).of(atRowId);
        }

        @Override
        public void toTop() {
            this.recordA.of(0L);
        }
    }
}

