/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.BinFunction;
import io.questdb.griffin.engine.functions.NoArgFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.BinarySequence;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndBinCCCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_bin(lli)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        long lo = args.getQuick(0).getLong(null);
        long hi = args.getQuick(1).getLong(null);
        int nullRate = args.getQuick(2).getInt(null);
        if (nullRate < 0) {
            throw SqlException.$(args.getQuick(2).getPosition(), "invalid null rate");
        }
        if (lo > hi) {
            throw SqlException.$(position, "invalid range");
        }
        if (lo < 1L) {
            throw SqlException.$(args.getQuick(0).getPosition(), "minimum has to be grater than 0");
        }
        if (lo < hi) {
            return new VarLenFunction(position, lo, hi, nullRate, configuration);
        }
        return new FixLenFunction(position, lo, nullRate, configuration);
    }

    private static class Sequence
    implements BinarySequence {
        private Rnd rnd;
        private long len;

        private Sequence() {
        }

        @Override
        public byte byteAt(long index) {
            return this.rnd.nextByte();
        }

        @Override
        public long length() {
            return this.len;
        }
    }

    private static final class FixLenFunction
    extends BinFunction
    implements StatelessFunction,
    NoArgFunction {
        private final Sequence sequence = new Sequence();
        private final Rnd rnd;
        private final int nullRate;

        public FixLenFunction(int position, long len, int nullRate, CairoConfiguration configuration) {
            super(position);
            this.nullRate = nullRate + 1;
            this.rnd = SharedRandom.getRandom(configuration);
            this.sequence.rnd = this.rnd;
            this.sequence.len = len;
        }

        @Override
        public BinarySequence getBin(Record rec) {
            if (this.rnd.nextPositiveInt() % this.nullRate == 1) {
                return null;
            }
            return this.sequence;
        }

        @Override
        public long getBinLen(Record rec) {
            return this.sequence.len;
        }
    }

    private static final class VarLenFunction
    extends BinFunction
    implements StatelessFunction,
    NoArgFunction {
        private final Sequence sequence = new Sequence();
        private final Rnd rnd;
        private final long lo;
        private final long range;
        private final int nullRate;

        public VarLenFunction(int position, long lo, long hi, int nullRate, CairoConfiguration configuration) {
            super(position);
            this.lo = lo;
            this.range = hi - lo + 1L;
            this.nullRate = nullRate + 1;
            this.rnd = SharedRandom.getRandom(configuration);
            this.sequence.rnd = this.rnd;
        }

        @Override
        public BinarySequence getBin(Record rec) {
            if (this.rnd.nextPositiveInt() % this.nullRate == 1) {
                return null;
            }
            this.sequence.len = this.lo + this.sequence.rnd.nextPositiveLong() % this.range;
            return this.sequence;
        }

        @Override
        public long getBinLen(Record rec) {
            return this.sequence.len;
        }
    }
}

