/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.BinFunction;
import io.questdb.griffin.engine.functions.NoArgFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.BinarySequence;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndBinFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_bin()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new FixLenFunction(position, configuration);
    }

    private static class Sequence
    implements BinarySequence {
        private Rnd rnd;
        private long len;

        private Sequence() {
        }

        @Override
        public byte byteAt(long index) {
            return this.rnd.nextByte();
        }

        @Override
        public long length() {
            return this.len;
        }
    }

    private static final class FixLenFunction
    extends BinFunction
    implements StatelessFunction,
    NoArgFunction {
        private final Sequence sequence = new Sequence();

        public FixLenFunction(int position, CairoConfiguration configuration) {
            super(position);
            this.sequence.rnd = SharedRandom.getRandom(configuration);
            this.sequence.len = 32L;
        }

        @Override
        public BinarySequence getBin(Record rec) {
            return this.sequence;
        }

        @Override
        public long getBinLen(Record rec) {
            return this.sequence.len;
        }
    }
}

