/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.ByteFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndByteCCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_byte(ii)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        byte hi;
        byte lo = (byte)args.getQuick(0).getInt(null);
        if (lo < (hi = (byte)args.getQuick(1).getInt(null))) {
            return new RndFunction(position, lo, hi, configuration);
        }
        throw SqlException.position(position).put("invalid range");
    }

    private static class RndFunction
    extends ByteFunction
    implements StatelessFunction {
        private final byte lo;
        private final byte range;
        private final Rnd rnd;

        public RndFunction(int position, byte lo, byte hi, CairoConfiguration configuration) {
            super(position);
            this.lo = lo;
            this.range = (byte)(hi - lo + 1);
            this.rnd = SharedRandom.getRandom(configuration);
        }

        @Override
        public byte getByte(Record rec) {
            short s = this.rnd.nextShort();
            if (s < 0) {
                return (byte)(this.lo - s % this.range);
            }
            return (byte)(this.lo + s % this.range);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        }
    }
}

