/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.ByteFunction;
import io.questdb.griffin.engine.functions.NoArgFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndByteFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_byte()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new RndFunction(position, configuration);
    }

    private static class RndFunction
    extends ByteFunction
    implements StatelessFunction,
    NoArgFunction {
        private final byte lo = (byte)20;
        private final byte range = (byte)(127 - this.lo + 1);
        private final Rnd rnd;

        public RndFunction(int position, CairoConfiguration configuration) {
            super(position);
            this.rnd = SharedRandom.getRandom(configuration);
        }

        @Override
        public byte getByte(Record rec) {
            short s = this.rnd.nextShort();
            if (s < 0) {
                return (byte)(this.lo - s % this.range);
            }
            return (byte)(this.lo + s % this.range);
        }
    }
}

