/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.griffin.engine.functions.NoArgFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndDateFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_date()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new Func(position, configuration);
    }

    private static class Func
    extends DateFunction
    implements StatelessFunction,
    NoArgFunction {
        private final long lo;
        private final long range;
        private final Rnd rnd;

        public Func(int position, CairoConfiguration configuration) {
            super(position);
            this.lo = 0L;
            this.range = 10000000L;
            this.rnd = SharedRandom.getRandom(configuration);
        }

        @Override
        public long getDate(Record rec) {
            return this.lo + this.rnd.nextPositiveLong() % this.range;
        }
    }
}

