/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndDoubleCCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_double(i)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        int nanRate = args.getQuick(0).getInt(null);
        if (nanRate < 0) {
            throw SqlException.$(args.getQuick(0).getPosition(), "invalid NaN rate");
        }
        return new RndFunction(position, nanRate, configuration);
    }

    private static class RndFunction
    extends DoubleFunction
    implements StatelessFunction {
        private final int nanRate;
        private final Rnd rnd;

        public RndFunction(int position, int nanRate, CairoConfiguration configuration) {
            super(position);
            this.nanRate = nanRate + 1;
            this.rnd = SharedRandom.getRandom(configuration);
        }

        @Override
        public double getDouble(Record rec) {
            if (this.rnd.nextInt() % this.nanRate == 1) {
                return Double.NaN;
            }
            return this.rnd.nextDouble();
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        }
    }
}

