/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndIntCCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_int(iii)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        int lo = args.getQuick(0).getInt(null);
        int hi = args.getQuick(1).getInt(null);
        int nanRate = args.getQuick(2).getInt(null);
        if (nanRate < 0) {
            throw SqlException.$(args.getQuick(2).getPosition(), "invalid NaN rate");
        }
        if (lo < hi) {
            return new RndFunction(position, lo, hi, nanRate, configuration);
        }
        throw SqlException.position(position).put("invalid range");
    }

    private static class RndFunction
    extends IntFunction
    implements StatelessFunction {
        private final int lo;
        private final int range;
        private final int nanRate;
        private final Rnd rnd;

        public RndFunction(int position, int lo, int hi, int nanRate, CairoConfiguration configuration) {
            super(position);
            this.lo = lo;
            this.range = hi - lo + 1;
            this.nanRate = nanRate + 1;
            this.rnd = SharedRandom.getRandom(configuration);
        }

        @Override
        public int getInt(Record rec) {
            if (this.rnd.nextInt() % this.nanRate == 1) {
                return Integer.MIN_VALUE;
            }
            return this.lo + this.rnd.nextPositiveInt() % this.range;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        }
    }
}

