/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public class RndLong256FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_long256()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new RndFunction(position, configuration);
    }

    private static class RndFunction
    extends Long256Function
    implements StatelessFunction {
        private final Rnd rnd;
        private final Long256Impl long256A = new Long256Impl();
        private final Long256Impl long256B = new Long256Impl();

        public RndFunction(int position, CairoConfiguration configuration) {
            super(position);
            this.rnd = SharedRandom.getRandom(configuration);
        }

        @Override
        public Long256 getLong256A(Record rec) {
            return this.rndLong(this.long256A);
        }

        @NotNull
        private Long256 rndLong(Long256Impl long256) {
            long256.setLong0(this.rnd.nextLong());
            long256.setLong1(this.rnd.nextLong());
            long256.setLong2(this.rnd.nextLong());
            long256.setLong3(this.rnd.nextLong());
            return long256;
        }

        @Override
        public Long256 getLong256B(Record rec) {
            return this.rndLong(this.long256B);
        }

        @Override
        public void getLong256(Record rec, CharSink sink) {
            Numbers.appendLong256(this.rnd.nextLong(), this.rnd.nextLong(), this.rnd.nextLong(), this.rnd.nextLong(), sink);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        }
    }
}

