/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.NoArgFunction;
import io.questdb.griffin.engine.functions.ShortFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndShortCCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_short(ii)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        short hi;
        short lo = (short)args.getQuick(0).getInt(null);
        if (lo < (hi = (short)args.getQuick(1).getInt(null))) {
            return new RndFunction(position, lo, hi, configuration);
        }
        throw SqlException.position(position).put("invalid range");
    }

    private static class RndFunction
    extends ShortFunction
    implements StatelessFunction,
    NoArgFunction {
        private final short lo;
        private final short range;
        private final Rnd rnd;

        public RndFunction(int position, short lo, short hi, CairoConfiguration configuration) {
            super(position);
            this.lo = lo;
            this.range = (short)(hi - lo + 1);
            this.rnd = SharedRandom.getRandom(configuration);
        }

        @Override
        public short getShort(Record rec) {
            short s = this.rnd.nextShort();
            if (s < 0) {
                return (short)(this.lo - s % this.range);
            }
            return (short)(this.lo + s % this.range);
        }
    }
}

