/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.NoArgFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.rnd.RndStrFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_str(iii)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        int lo = args.getQuick(0).getInt(null);
        int hi = args.getQuick(1).getInt(null);
        int nullRate = args.getQuick(2).getInt(null);
        if (nullRate < 0) {
            throw SqlException.position(args.getQuick(2).getPosition()).put("rate must be positive");
        }
        if (lo < hi && lo > 0) {
            return new RndStrFunction(position, lo, hi, nullRate + 1, configuration);
        }
        if (lo == hi) {
            return new FixedFunction(position, lo, nullRate + 1, configuration);
        }
        throw SqlException.position(position).put("invalid range");
    }

    private static class FixedFunction
    extends StrFunction
    implements StatelessFunction,
    NoArgFunction {
        private final int len;
        private final int nullRate;
        private final Rnd rnd;

        public FixedFunction(int position, int len, int nullRate, CairoConfiguration configuration) {
            super(position);
            this.len = len;
            this.rnd = SharedRandom.getRandom(configuration);
            this.nullRate = nullRate;
        }

        @Override
        public CharSequence getStr(Record rec) {
            if (this.rnd.nextInt() % this.nullRate == 1) {
                return null;
            }
            return this.rnd.nextChars(this.len);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr(rec);
        }
    }
}

