/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.NoArgFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.rnd.RndStrFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndStringListFunctionFactory
implements FunctionFactory {
    static void copyConstants(ObjList<Function> args, ObjList<String> symbols) throws SqlException {
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            Function f = args.getQuick(i);
            if (f.isConstant()) {
                if (f.getType() == 10) {
                    symbols.add(Chars.toString(f.getStr(null)));
                    continue;
                }
                if (f.getType() == 3) {
                    symbols.add(new String(new char[]{f.getChar(null)}));
                    continue;
                }
            }
            throw SqlException.$(f.getPosition(), "STRING constant expected");
        }
    }

    @Override
    public String getSignature() {
        return "rnd_str(V)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        if (args == null) {
            return new RndStrFunction(position, 3, 10, 1, configuration);
        }
        ObjList<String> symbols = new ObjList<String>(args.size());
        RndStringListFunctionFactory.copyConstants(args, symbols);
        return new Func(position, symbols, configuration);
    }

    private static final class Func
    extends StrFunction
    implements StatelessFunction,
    NoArgFunction {
        private final ObjList<String> symbols;
        private final Rnd rnd;
        private final int count;

        public Func(int position, ObjList<String> symbols, CairoConfiguration configuration) {
            super(position);
            this.rnd = SharedRandom.getRandom(configuration);
            this.symbols = symbols;
            this.count = symbols.size();
        }

        @Override
        public CharSequence getStr(Record rec) {
            return this.symbols.getQuick(this.rnd.nextPositiveInt() % this.count);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr(rec);
        }
    }
}

