/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_symbol(iiii)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        int count = args.getQuick(0).getInt(null);
        int lo = args.getQuick(1).getInt(null);
        int hi = args.getQuick(2).getInt(null);
        int nullRate = args.getQuick(3).getInt(null);
        if (count < 1) {
            throw SqlException.$(args.getQuick(0).getPosition(), "invalid symbol count");
        }
        if (lo > hi || lo < 1) {
            throw SqlException.$(position, "invalid range");
        }
        if (nullRate < 0) {
            throw SqlException.position(args.getQuick(3).getPosition()).put("rate must be positive");
        }
        return new Func(position, count, lo, hi, nullRate, configuration);
    }

    private static final class Func
    extends SymbolFunction
    implements StatelessFunction {
        private final int count;
        private final int lo;
        private final int hi;
        private final int nullRate;
        private final ObjList<String> symbols;
        private final Rnd rnd;

        public Func(int position, int count, int lo, int hi, int nullRate, CairoConfiguration configuration) {
            super(position);
            this.count = count;
            this.lo = lo;
            this.hi = hi;
            this.nullRate = nullRate + 1;
            this.rnd = SharedRandom.getRandom(configuration);
            this.symbols = new ObjList(count);
            this.seedSymbols();
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            return this.symbols.getQuick(TableUtils.toIndexKey(this.next()));
        }

        private int next() {
            if (this.rnd.nextPositiveInt() % this.nullRate == 1) {
                return Integer.MIN_VALUE;
            }
            return this.rnd.nextPositiveInt() % this.count;
        }

        private void seedFixed() {
            for (int i = 0; i < this.count; ++i) {
                this.symbols.add(Chars.toString(this.rnd.nextChars(this.lo)));
            }
        }

        private void seedSymbols() {
            this.symbols.clear();
            this.symbols.add(null);
            if (this.lo == this.hi) {
                this.seedFixed();
            } else {
                this.seedVariable();
            }
        }

        private void seedVariable() {
            int range = this.hi - this.lo + 1;
            for (int i = 0; i < this.count; ++i) {
                this.symbols.add(this.rnd.nextChars(this.lo + this.rnd.nextPositiveInt() % range).toString());
            }
        }

        @Override
        public CharSequence valueOf(int symbolKey) {
            return this.symbols.getQuick(TableUtils.toIndexKey(symbolKey));
        }

        @Override
        public int getInt(Record rec) {
            return this.next();
        }

        @Override
        public boolean isSymbolTableStatic() {
            return false;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        }
    }
}

