/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.NoArgFunction;
import io.questdb.griffin.engine.functions.StatelessFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_timestamp(nni)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        long lo = args.getQuick(0).getTimestamp(null);
        long hi = args.getQuick(1).getTimestamp(null);
        int nanRate = args.getQuick(2).getInt(null);
        if (nanRate < 0) {
            throw SqlException.$(args.getQuick(2).getPosition(), "invalid NaN rate");
        }
        if (lo < hi) {
            return new Func(position, lo, hi, nanRate, configuration);
        }
        throw SqlException.$(position, "invalid range");
    }

    private static class Func
    extends TimestampFunction
    implements StatelessFunction,
    NoArgFunction {
        private final long lo;
        private final long range;
        private final int nanRate;
        private final Rnd rnd;

        public Func(int position, long lo, long hi, int nanRate, CairoConfiguration configuration) {
            super(position);
            this.lo = lo;
            this.range = hi - lo + 1L;
            this.nanRate = nanRate + 1;
            this.rnd = SharedRandom.getRandom(configuration);
        }

        @Override
        public long getTimestamp(Record rec) {
            if (this.rnd.nextInt() % this.nanRate == 1) {
                return Long.MIN_VALUE;
            }
            return this.lo + this.rnd.nextPositiveLong() % this.range;
        }
    }
}

