/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.ObjList;

public class LengthSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "length(K)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new LengthSymbolVFunc(position, args.getQuick(0));
    }

    private static class LengthSymbolVFunc
    extends IntFunction
    implements UnaryFunction {
        private final Function arg;

        public LengthSymbolVFunc(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public int getInt(Record rec) {
            CharSequence symbol = this.arg.getSymbol(rec);
            return symbol == null ? -1 : symbol.length();
        }
    }
}

