/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class SubStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "substr(SI)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
        return new Func(position, args.getQuick(0), args.getQuick(1));
    }

    private static class Func
    extends StrFunction
    implements BinaryFunction {
        private final StringSink sink = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final Function var;
        private final Function start;

        public Func(int position, Function var, Function start) {
            super(position);
            this.var = var;
            this.start = start;
        }

        @Override
        public Function getLeft() {
            return this.var;
        }

        @Override
        public Function getRight() {
            return this.start;
        }

        @Override
        public CharSequence getStr(Record rec) {
            CharSequence str = this.var.getStr(rec);
            if (str == null) {
                return null;
            }
            int start = this.start.getInt(rec);
            if (start == Integer.MIN_VALUE) {
                return null;
            }
            this.sink.clear();
            int len = str.length();
            if (start > -1 && start < len) {
                this.sink.put(str, start, len);
            }
            return this.sink;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence str = this.var.getStrB(rec);
            if (str == null) {
                return null;
            }
            int start = this.start.getInt(rec);
            if (start == Integer.MIN_VALUE) {
                return null;
            }
            this.sinkB.clear();
            int len = str.length();
            if (start > -1 && start < len) {
                this.sinkB.put(str, start, len);
            }
            return this.sinkB;
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            CharSequence str = this.var.getStr(rec);
            if (str == null) {
                return;
            }
            int start = this.start.getInt(rec);
            if (start == Integer.MIN_VALUE) {
                return;
            }
            int len = str.length();
            if (start > -1 && start < len) {
                sink.put(str, start, len);
            }
        }

        @Override
        public int getStrLen(Record rec) {
            int len = this.var.getStrLen(rec);
            if (len == -1) {
                return len;
            }
            int start = this.start.getInt(rec);
            if (start == Integer.MIN_VALUE) {
                return -1;
            }
            return start > -1 && start < len ? len - start : 0;
        }
    }
}

