/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.VirtualRecordNoRowid;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableRecordCursor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class GroupByNotKeyedRecordCursorFactory
implements RecordCursorFactory {
    protected final RecordCursorFactory base;
    private final GroupByNotKeyedRecordCursor cursor;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final RecordMetadata metadata;
    private final SimpleMapValue simpleMapValue;
    private final VirtualRecord virtualRecordA;
    private final VirtualRecord virtualRecordB;

    public GroupByNotKeyedRecordCursorFactory(RecordCursorFactory base, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int valueCount) {
        this.simpleMapValue = new SimpleMapValue(valueCount);
        this.base = base;
        this.metadata = groupByMetadata;
        this.groupByFunctions = groupByFunctions;
        this.virtualRecordA = new VirtualRecordNoRowid(recordFunctions);
        this.virtualRecordA.of(this.simpleMapValue);
        this.virtualRecordB = new VirtualRecordNoRowid(recordFunctions);
        this.virtualRecordB.of(this.simpleMapValue);
        this.cursor = new GroupByNotKeyedRecordCursor();
    }

    @Override
    public void close() {
        Misc.freeObjList(this.groupByFunctions);
        Misc.free(this.base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            Record baseRecord = baseCursor.getRecord();
            int n = this.groupByFunctions.size();
            if (baseCursor.hasNext()) {
                GroupByUtils.updateNew(this.groupByFunctions, n, this.simpleMapValue, baseRecord);
            } else {
                EmptyTableRecordCursor emptyTableRecordCursor = EmptyTableRecordCursor.INSTANCE;
                return emptyTableRecordCursor;
            }
            while (baseCursor.hasNext()) {
                GroupByUtils.updateExisting(this.groupByFunctions, n, this.simpleMapValue, baseRecord);
            }
            this.cursor.toTop();
            int m = this.groupByFunctions.size();
            for (int i = 0; i < m; ++i) {
                this.groupByFunctions.getQuick(i).init(this.cursor, executionContext);
            }
        }
        finally {
            Misc.free(baseCursor);
        }
        return this.cursor;
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    private class GroupByNotKeyedRecordCursor
    implements NoRandomAccessRecordCursor {
        private int recordsRemaining = 1;

        private GroupByNotKeyedRecordCursor() {
        }

        @Override
        public void close() {
        }

        @Override
        public Record getRecord() {
            return GroupByNotKeyedRecordCursorFactory.this.virtualRecordA;
        }

        @Override
        public Record getRecordB() {
            return GroupByNotKeyedRecordCursorFactory.this.virtualRecordB;
        }

        @Override
        public boolean hasNext() {
            return this.recordsRemaining-- > 0;
        }

        @Override
        public void toTop() {
            this.recordsRemaining = 1;
        }

        @Override
        public long size() {
            return 1L;
        }
    }
}

