/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.columns.BinColumn;
import io.questdb.griffin.engine.functions.columns.BooleanColumn;
import io.questdb.griffin.engine.functions.columns.ByteColumn;
import io.questdb.griffin.engine.functions.columns.CharColumn;
import io.questdb.griffin.engine.functions.columns.DateColumn;
import io.questdb.griffin.engine.functions.columns.DoubleColumn;
import io.questdb.griffin.engine.functions.columns.FloatColumn;
import io.questdb.griffin.engine.functions.columns.IntColumn;
import io.questdb.griffin.engine.functions.columns.Long256Column;
import io.questdb.griffin.engine.functions.columns.LongColumn;
import io.questdb.griffin.engine.functions.columns.ShortColumn;
import io.questdb.griffin.engine.functions.columns.StrColumn;
import io.questdb.griffin.engine.functions.columns.TimestampColumn;
import io.questdb.griffin.engine.groupby.MapSymbolColumn;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class GroupByUtils {
    public static void prepareGroupByFunctions(QueryModel model, RecordMetadata metadata, FunctionParser functionParser, SqlExecutionContext executionContext, ObjList<GroupByFunction> groupByFunctions, ArrayColumnTypes valueTypes) throws SqlException {
        ObjList<QueryColumn> columns = model.getColumns();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn column = columns.getQuick(i);
            ExpressionNode node = column.getAst();
            if (node.type == 4) continue;
            Function function = functionParser.parseFunction(column.getAst(), metadata, executionContext);
            assert (function instanceof GroupByFunction);
            GroupByFunction func = (GroupByFunction)function;
            func.pushValueTypes(valueTypes);
            groupByFunctions.add(func);
        }
    }

    public static IntList prepareGroupByRecordFunctions(@NotNull QueryModel model, RecordMetadata metadata, @NotNull ListColumnFilter listColumnFilter, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, GenericRecordMetadata groupByMetadata, ArrayColumnTypes keyTypes, int keyColumnIndex, boolean timestampUnimportant, int timestampIndex) throws SqlException {
        ObjList<QueryColumn> columns = model.getColumns();
        IntList symbolTableSkewIndex = null;
        int valueColumnIndex = 0;
        int lastIndex = -1;
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            int type;
            QueryColumn column = columns.getQuick(i);
            ExpressionNode node = column.getAst();
            if (node.type == 4) {
                int index = metadata.getColumnIndexQuiet(node.token);
                if (index == -1) {
                    throw SqlException.invalidColumn(node.position, node.token);
                }
                type = metadata.getColumnType(index);
                if (index != timestampIndex || timestampUnimportant) {
                    Function fun;
                    if (lastIndex != index) {
                        listColumnFilter.add(index);
                        keyTypes.add(type);
                        ++keyColumnIndex;
                        lastIndex = index;
                    }
                    switch (type) {
                        case 0: {
                            fun = new BooleanColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 1: {
                            fun = new ByteColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 2: {
                            fun = new ShortColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 3: {
                            fun = new CharColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 4: {
                            fun = new IntColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 5: {
                            fun = new LongColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 8: {
                            fun = new FloatColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 9: {
                            fun = new DoubleColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 10: {
                            fun = new StrColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 11: {
                            if (symbolTableSkewIndex == null) {
                                symbolTableSkewIndex = new IntList();
                            }
                            symbolTableSkewIndex.extendAndSet(i, index);
                            fun = new MapSymbolColumn(node.position, keyColumnIndex - 1, i, metadata.isSymbolTableStatic(index));
                            break;
                        }
                        case 6: {
                            fun = new DateColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 7: {
                            fun = new TimestampColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 12: {
                            fun = new Long256Column(node.position, keyColumnIndex - 1);
                            break;
                        }
                        default: {
                            fun = new BinColumn(node.position, keyColumnIndex - 1);
                        }
                    }
                    recordFunctions.add(fun);
                } else {
                    recordFunctions.add(null);
                    if (groupByMetadata.getTimestampIndex() == -1) {
                        groupByMetadata.setTimestampIndex(i);
                    }
                    assert (type == 7);
                }
                groupByMetadata.add(new TableColumnMetadata(Chars.toString(column.getName()), type, metadata.isColumnIndexed(index), metadata.getIndexValueBlockCapacity(index), metadata.isSymbolTableStatic(index)));
                continue;
            }
            GroupByFunction groupByFunction = groupByFunctions.getQuick(valueColumnIndex++);
            recordFunctions.add(groupByFunction);
            type = groupByFunction.getType();
            groupByMetadata.add(new TableColumnMetadata(Chars.toString(column.getName()), type, false, 0, groupByFunction instanceof SymbolFunction && ((SymbolFunction)((Object)groupByFunction)).isSymbolTableStatic()));
        }
        return symbolTableSkewIndex;
    }

    static void updateFunctions(ObjList<GroupByFunction> groupByFunctions, int n, MapValue value, Record record) {
        if (value.isNew()) {
            GroupByUtils.updateNew(groupByFunctions, n, value, record);
        } else {
            GroupByUtils.updateExisting(groupByFunctions, n, value, record);
        }
    }

    public static void updateExisting(ObjList<GroupByFunction> groupByFunctions, int n, MapValue value, Record record) {
        for (int i = 0; i < n; ++i) {
            groupByFunctions.getQuick(i).computeNext(value, record);
        }
    }

    public static void updateNew(ObjList<GroupByFunction> groupByFunctions, int n, MapValue value, Record record) {
        for (int i = 0; i < n; ++i) {
            groupByFunctions.getQuick(i).computeFirst(value, record);
        }
    }
}

