/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;
import org.jetbrains.annotations.Nullable;

public class MapSymbolColumn
extends SymbolFunction {
    private final int mapColumnIndex;
    private final int cursorColumnIndex;
    private final boolean symbolTableStatic;
    private SymbolTable symbolTable;

    public MapSymbolColumn(int position, int mapColumnIndex, int cursorColumnIndex, boolean symbolTableStatic) {
        super(position);
        this.mapColumnIndex = mapColumnIndex;
        this.cursorColumnIndex = cursorColumnIndex;
        this.symbolTableStatic = symbolTableStatic;
    }

    @Override
    public int getInt(Record rec) {
        return rec.getInt(this.mapColumnIndex);
    }

    @Override
    public CharSequence getSymbol(Record rec) {
        return this.symbolTable.valueOf(this.getInt(rec));
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        this.symbolTable = symbolTableSource.getSymbolTable(this.cursorColumnIndex);
        assert (this.symbolTable != this);
        assert (this.symbolTable != null);
    }

    @Override
    public CharSequence valueOf(int symbolKey) {
        return this.symbolTable.valueOf(symbolKey);
    }

    @Override
    @Nullable
    public StaticSymbolTable getStaticSymbolTable() {
        return this.symbolTable instanceof StaticSymbolTable ? (StaticSymbolTable)this.symbolTable : null;
    }

    @Override
    public boolean isSymbolTableStatic() {
        return this.symbolTableStatic;
    }
}

