/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.VirtualRecordNoRowid;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.NoArgFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

class SampleByFillNoneNotKeyedRecordCursor
implements DelegatingRecordCursor,
NoRandomAccessRecordCursor {
    private final ObjList<GroupByFunction> groupByFunctions;
    private final int timestampIndex;
    private final TimestampSampler timestampSampler;
    private final IntList symbolTableSkewIndex;
    private final SimpleMapValue simpleMapValue;
    private final VirtualRecord record;
    private RecordCursor base;
    private Record baseRecord;
    private long lastTimestamp;
    private long nextTimestamp;

    public SampleByFillNoneNotKeyedRecordCursor(SimpleMapValue simpleMapValue, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler, IntList symbolTableSkewIndex) {
        this.simpleMapValue = simpleMapValue;
        this.groupByFunctions = groupByFunctions;
        this.timestampIndex = timestampIndex;
        this.timestampSampler = timestampSampler;
        this.symbolTableSkewIndex = symbolTableSkewIndex;
        int n = recordFunctions.size();
        for (int i = 0; i < n; ++i) {
            Function f = recordFunctions.getQuick(i);
            if (f != null) continue;
            recordFunctions.setQuick(i, new TimestampFunc(0));
        }
        this.record = new VirtualRecordNoRowid(recordFunctions);
        this.record.of(simpleMapValue);
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.base.getSymbolTable(this.symbolTableSkewIndex.get(columnIndex));
    }

    @Override
    public boolean hasNext() {
        if (this.baseRecord == null) {
            return false;
        }
        this.lastTimestamp = this.nextTimestamp;
        int n = this.groupByFunctions.size();
        GroupByUtils.updateNew(this.groupByFunctions, n, this.simpleMapValue, this.baseRecord);
        while (this.base.hasNext()) {
            long timestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
            if (this.lastTimestamp == timestamp) {
                GroupByUtils.updateExisting(this.groupByFunctions, n, this.simpleMapValue, this.baseRecord);
                continue;
            }
            this.nextTimestamp = timestamp;
            return true;
        }
        this.baseRecord = null;
        return true;
    }

    @Override
    public void toTop() {
        this.base.toTop();
        if (this.base.hasNext()) {
            this.baseRecord = this.base.getRecord();
            this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
        }
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void of(RecordCursor base) {
        this.base = base;
        this.baseRecord = base.getRecord();
        this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
    }

    private class TimestampFunc
    extends TimestampFunction
    implements NoArgFunction {
        public TimestampFunc(int position) {
            super(position);
        }

        @Override
        public long getTimestamp(Record rec) {
            return SampleByFillNoneNotKeyedRecordCursor.this.lastTimestamp;
        }
    }
}

