/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.sql.VirtualRecordNoRowid;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

class SampleByFillNoneRecordCursor
implements DelegatingRecordCursor,
NoRandomAccessRecordCursor {
    private final Map map;
    private final RecordSink keyMapSink;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final int timestampIndex;
    private final TimestampSampler timestampSampler;
    private final Record record;
    private final IntList symbolTableSkewIndex;
    private final RecordCursor mapCursor;
    private RecordCursor base;
    private Record baseRecord;
    private long lastTimestamp;
    private long nextTimestamp;

    public SampleByFillNoneRecordCursor(Map map, RecordSink keyMapSink, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler, IntList symbolTableSkewIndex) {
        this.map = map;
        this.groupByFunctions = groupByFunctions;
        this.timestampIndex = timestampIndex;
        this.keyMapSink = keyMapSink;
        this.timestampSampler = timestampSampler;
        VirtualRecordNoRowid rec = new VirtualRecordNoRowid(recordFunctions);
        rec.of(map.getRecord());
        this.record = rec;
        this.symbolTableSkewIndex = symbolTableSkewIndex;
        int n = recordFunctions.size();
        for (int i = 0; i < n; ++i) {
            Function f = recordFunctions.getQuick(i);
            if (f != null) continue;
            recordFunctions.setQuick(i, new TimestampFunc(0));
        }
        this.mapCursor = map.getCursor();
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.base.getSymbolTable(this.symbolTableSkewIndex.get(columnIndex));
    }

    @Override
    public boolean hasNext() {
        return this.mapHasNext() || this.baseRecord != null && this.computeNextBatch();
    }

    private boolean computeNextBatch() {
        this.lastTimestamp = this.nextTimestamp;
        this.map.clear();
        int n = this.groupByFunctions.size();
        do {
            long timestamp;
            if (this.lastTimestamp != (timestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex)))) {
                this.nextTimestamp = timestamp;
                return this.createMapCursor();
            }
            MapKey key = this.map.withKey();
            this.keyMapSink.copy(this.baseRecord, key);
            GroupByUtils.updateFunctions(this.groupByFunctions, n, key.createValue(), this.baseRecord);
        } while (this.base.hasNext());
        this.baseRecord = null;
        return this.createMapCursor();
    }

    private boolean createMapCursor() {
        this.map.getCursor();
        return this.mapHasNext();
    }

    @Override
    public void toTop() {
        this.base.toTop();
        if (this.base.hasNext()) {
            this.baseRecord = this.base.getRecord();
            this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
            this.map.clear();
        }
    }

    @Override
    public void of(RecordCursor base) {
        this.base = base;
        this.baseRecord = base.getRecord();
        this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
    }

    private boolean mapHasNext() {
        return this.mapCursor.hasNext();
    }

    private class TimestampFunc
    extends TimestampFunction {
        public TimestampFunc(int position) {
            super(position);
        }

        @Override
        public long getTimestamp(Record rec) {
            return SampleByFillNoneRecordCursor.this.lastTimestamp;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        }
    }
}

