/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableRecordCursor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.SampleByFillNoneRecordCursor;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillNoneRecordCursorFactory
implements RecordCursorFactory {
    protected final RecordCursorFactory base;
    protected final Map map;
    private final SampleByFillNoneRecordCursor cursor;
    private final ObjList<Function> recordFunctions;
    private final RecordMetadata metadata;

    public SampleByFillNoneRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, RecordMetadata groupByMetadata, @NotNull ObjList<GroupByFunction> groupByFunctions, @NotNull ObjList<Function> recordFunctions, IntList symbolTableIndex, @NotNull TimestampSampler timestampSampler, @NotNull ListColumnFilter listColumnFilter, @NotNull BytecodeAssembler asm, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, int timestampIndex) {
        this.recordFunctions = recordFunctions;
        RecordSink mapSink = RecordSinkFactory.getInstance(asm, base.getMetadata(), listColumnFilter, false);
        this.map = MapFactory.createMap(configuration, keyTypes, valueTypes);
        try {
            this.base = base;
            this.metadata = groupByMetadata;
            this.cursor = new SampleByFillNoneRecordCursor(this.map, mapSink, groupByFunctions, this.recordFunctions, timestampIndex, timestampSampler, symbolTableIndex);
        }
        catch (CairoException e) {
            Misc.free(this.map);
            Misc.freeObjList(recordFunctions);
            throw e;
        }
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        if (baseCursor.hasNext()) {
            this.map.clear();
            return this.initFunctionsAndCursor(executionContext, baseCursor);
        }
        baseCursor.close();
        return EmptyTableRecordCursor.INSTANCE;
    }

    @Override
    public void close() {
        Misc.freeObjList(this.recordFunctions);
        Misc.free(this.map);
        Misc.free(this.base);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @NotNull
    protected RecordCursor initFunctionsAndCursor(SqlExecutionContext executionContext, RecordCursor baseCursor) {
        this.cursor.of(baseCursor);
        int m = this.recordFunctions.size();
        for (int i = 0; i < m; ++i) {
            this.recordFunctions.getQuick(i).init(this.cursor, executionContext);
        }
        return this.cursor;
    }
}

