/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.VirtualRecordNoRowid;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.NoArgFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

class SampleByFillPrevRecordCursor
implements DelegatingRecordCursor,
NoRandomAccessRecordCursor {
    private final Map map;
    private final RecordSink keyMapSink;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final int timestampIndex;
    private final TimestampSampler timestampSampler;
    private final Record record;
    private final IntList symbolTableSkewIndex;
    private final RecordCursor mapCursor;
    private RecordCursor base;
    private Record baseRecord;
    private long lastTimestamp;
    private long nextTimestamp;

    public SampleByFillPrevRecordCursor(Map map, RecordSink keyMapSink, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler, IntList symbolTableSkewIndex) {
        this.map = map;
        this.groupByFunctions = groupByFunctions;
        this.timestampIndex = timestampIndex;
        this.keyMapSink = keyMapSink;
        this.timestampSampler = timestampSampler;
        VirtualRecordNoRowid rec = new VirtualRecordNoRowid(recordFunctions);
        rec.of(map.getRecord());
        this.record = rec;
        this.symbolTableSkewIndex = symbolTableSkewIndex;
        int n = recordFunctions.size();
        for (int i = 0; i < n; ++i) {
            Function f = recordFunctions.getQuick(i);
            if (f != null) continue;
            recordFunctions.setQuick(i, new TimestampFunc(0));
        }
        this.mapCursor = map.getCursor();
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.base.getSymbolTable(this.symbolTableSkewIndex.get(columnIndex));
    }

    @Override
    public boolean hasNext() {
        block9: {
            long timestamp;
            if (this.mapCursor.hasNext()) {
                return true;
            }
            if (this.baseRecord == null) {
                return false;
            }
            long nextTimestamp = this.timestampSampler.nextTimestamp(this.lastTimestamp);
            if (this.nextTimestamp > nextTimestamp) {
                this.lastTimestamp = nextTimestamp;
                return this.map.getCursor().hasNext();
            }
            this.lastTimestamp = this.nextTimestamp;
            int n = this.groupByFunctions.size();
            while (this.lastTimestamp == (timestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex)))) {
                int i;
                MapKey key = this.map.withKey();
                this.keyMapSink.copy(this.baseRecord, key);
                MapValue value = key.findValue();
                assert (value != null);
                if (value.getLong(0) != timestamp) {
                    value.putLong(0, timestamp);
                    for (i = 0; i < n; ++i) {
                        this.groupByFunctions.getQuick(i).computeFirst(value, this.baseRecord);
                    }
                } else {
                    for (i = 0; i < n; ++i) {
                        this.groupByFunctions.getQuick(i).computeNext(value, this.baseRecord);
                    }
                }
                if (this.base.hasNext()) continue;
                this.baseRecord = null;
                break block9;
            }
            this.nextTimestamp = timestamp;
        }
        return this.map.getCursor().hasNext();
    }

    @Override
    public void toTop() {
        this.base.toTop();
        if (this.base.hasNext()) {
            this.baseRecord = this.base.getRecord();
            this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
            int n = this.groupByFunctions.size();
            RecordCursor mapCursor = this.map.getCursor();
            MapRecord mapRecord = this.map.getRecord();
            while (mapCursor.hasNext()) {
                MapValue value = mapRecord.getValue();
                value.putLong(0, Long.MIN_VALUE);
                for (int i = 0; i < n; ++i) {
                    this.groupByFunctions.getQuick(i).setNull(value);
                }
            }
        }
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void of(RecordCursor base) {
        this.base = base;
        this.baseRecord = base.getRecord();
        this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
    }

    private class TimestampFunc
    extends TimestampFunction
    implements NoArgFunction {
        public TimestampFunc(int position) {
            super(position);
        }

        @Override
        public long getTimestamp(Record rec) {
            return SampleByFillPrevRecordCursor.this.lastTimestamp;
        }
    }
}

