/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableRecordCursor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.SampleByFillPrevRecordCursor;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillPrevRecordCursorFactory
implements RecordCursorFactory {
    protected final RecordCursorFactory base;
    protected final Map map;
    private final DelegatingRecordCursor cursor;
    private final ObjList<Function> recordFunctions;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final RecordSink mapSink;
    private final RecordMetadata metadata;

    public SampleByFillPrevRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull TimestampSampler timestampSampler, @NotNull ListColumnFilter listColumnFilter, @NotNull BytecodeAssembler asm, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, IntList symbolTableSkewIndex, int timestampIndex) {
        this.mapSink = RecordSinkFactory.getInstance(asm, base.getMetadata(), listColumnFilter, false);
        this.map = MapFactory.createMap(configuration, keyTypes, valueTypes);
        this.groupByFunctions = groupByFunctions;
        this.recordFunctions = recordFunctions;
        try {
            this.base = base;
            this.metadata = groupByMetadata;
            this.cursor = new SampleByFillPrevRecordCursor(this.map, this.mapSink, groupByFunctions, recordFunctions, timestampIndex, timestampSampler, symbolTableSkewIndex);
        }
        catch (CairoException e) {
            Misc.freeObjList(recordFunctions);
            Misc.free(this.map);
            throw e;
        }
    }

    @Override
    public void close() {
        Misc.freeObjList(this.recordFunctions);
        Misc.free(this.map);
        Misc.free(this.base);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        this.map.clear();
        int n = this.groupByFunctions.size();
        Record baseCursorRecord = baseCursor.getRecord();
        while (baseCursor.hasNext()) {
            MapKey key = this.map.withKey();
            this.mapSink.copy(baseCursorRecord, key);
            MapValue value = key.createValue();
            if (!value.isNew()) continue;
            value.putLong(0, Long.MIN_VALUE);
            for (int i = 0; i < n; ++i) {
                this.groupByFunctions.getQuick(i).setNull(value);
            }
        }
        if (this.map.size() == 0L) {
            baseCursor.close();
            return EmptyTableRecordCursor.INSTANCE;
        }
        baseCursor.toTop();
        boolean next = baseCursor.hasNext();
        assert (next);
        return this.initFunctionsAndCursor(executionContext, baseCursor);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @NotNull
    protected RecordCursor initFunctionsAndCursor(SqlExecutionContext executionContext, RecordCursor baseCursor) {
        this.cursor.of(baseCursor);
        int m = this.recordFunctions.size();
        for (int i = 0; i < m; ++i) {
            this.recordFunctions.getQuick(i).init(this.cursor, executionContext);
        }
        return this.cursor;
    }
}

