/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.NoArgFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.groupby.SplitVirtualRecord;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class SampleByFillValueNotKeyedRecordCursor
implements DelegatingRecordCursor,
NoRandomAccessRecordCursor {
    private final ObjList<GroupByFunction> groupByFunctions;
    private final int timestampIndex;
    private final TimestampSampler timestampSampler;
    private final SplitVirtualRecord record;
    private final IntList symbolTableSkewIndex;
    private final SimpleMapValue simpleMapValue;
    private RecordCursor base;
    private Record baseRecord;
    private long lastTimestamp;
    private long nextTimestamp;

    public SampleByFillValueNotKeyedRecordCursor(ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, ObjList<Function> placeholderFunctions, int timestampIndex, TimestampSampler timestampSampler, IntList symbolTableSkewIndex, SimpleMapValue simpleMapValue) {
        this.simpleMapValue = simpleMapValue;
        this.groupByFunctions = groupByFunctions;
        this.timestampIndex = timestampIndex;
        this.timestampSampler = timestampSampler;
        this.record = new SplitVirtualRecord(recordFunctions, placeholderFunctions);
        this.record.of(simpleMapValue);
        this.symbolTableSkewIndex = symbolTableSkewIndex;
        assert (recordFunctions.size() == placeholderFunctions.size());
        TimestampFunc timestampFunc = new TimestampFunc(0);
        int n = recordFunctions.size();
        for (int i = 0; i < n; ++i) {
            Function f = recordFunctions.getQuick(i);
            if (f != null) continue;
            recordFunctions.setQuick(i, timestampFunc);
            placeholderFunctions.setQuick(i, timestampFunc);
        }
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.base.getSymbolTable(this.symbolTableSkewIndex.get(columnIndex));
    }

    @Override
    public boolean hasNext() {
        if (this.baseRecord == null) {
            return false;
        }
        long nextTimestamp = this.timestampSampler.nextTimestamp(this.lastTimestamp);
        if (this.nextTimestamp > nextTimestamp) {
            this.lastTimestamp = nextTimestamp;
            this.record.setActiveB();
            return true;
        }
        this.lastTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
        this.record.setActiveA();
        int n = this.groupByFunctions.size();
        for (int i = 0; i < n; ++i) {
            this.groupByFunctions.getQuick(i).computeFirst(this.simpleMapValue, this.baseRecord);
        }
        while (this.base.hasNext()) {
            long timestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
            if (this.lastTimestamp == timestamp) {
                for (int i = 0; i < n; ++i) {
                    this.groupByFunctions.getQuick(i).computeNext(this.simpleMapValue, this.baseRecord);
                }
                continue;
            }
            this.nextTimestamp = timestamp;
            return true;
        }
        this.baseRecord = null;
        return true;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void toTop() {
        this.base.toTop();
        if (this.base.hasNext()) {
            this.baseRecord = this.base.getRecord();
            this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
        }
    }

    @Override
    public void of(RecordCursor base) {
        this.base = base;
        this.baseRecord = base.getRecord();
        this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
    }

    private class TimestampFunc
    extends TimestampFunction
    implements NoArgFunction {
        public TimestampFunc(int position) {
            super(position);
        }

        @Override
        public long getTimestamp(Record rec) {
            return SampleByFillValueNotKeyedRecordCursor.this.lastTimestamp;
        }
    }
}

