/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableRecordCursor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.constants.ByteConstant;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.griffin.engine.functions.constants.FloatConstant;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.functions.constants.ShortConstant;
import io.questdb.griffin.engine.groupby.SampleByFillValueRecordCursor;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillValueRecordCursorFactory
implements RecordCursorFactory {
    protected final RecordCursorFactory base;
    protected final Map map;
    private final DelegatingRecordCursor cursor;
    private final ObjList<Function> recordFunctions;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final RecordSink mapSink;
    private final RecordMetadata metadata;

    public SampleByFillValueRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull TimestampSampler timestampSampler, @NotNull ListColumnFilter listColumnFilter, @NotNull BytecodeAssembler asm, @NotNull ObjList<ExpressionNode> fillValues, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, IntList symbolTableSkewIndex, int timestampIndex) throws SqlException {
        this.mapSink = RecordSinkFactory.getInstance(asm, base.getMetadata(), listColumnFilter, false);
        this.map = MapFactory.createMap(configuration, keyTypes, valueTypes);
        try {
            this.base = base;
            this.metadata = groupByMetadata;
            this.recordFunctions = recordFunctions;
            this.groupByFunctions = groupByFunctions;
            ObjList<Function> placeholderFunctions = SampleByFillValueRecordCursorFactory.createPlaceholderFunctions(recordFunctions, fillValues);
            this.cursor = new SampleByFillValueRecordCursor(this.map, this.mapSink, groupByFunctions, recordFunctions, placeholderFunctions, timestampIndex, timestampSampler, symbolTableSkewIndex);
        }
        catch (CairoException | SqlException e) {
            Misc.freeObjList(recordFunctions);
            Misc.free(this.map);
            throw e;
        }
    }

    @NotNull
    public static ObjList<Function> createPlaceholderFunctions(ObjList<Function> recordFunctions, @NotNull ObjList<ExpressionNode> fillValues) throws SqlException {
        ObjList<Function> placeholderFunctions = new ObjList<Function>();
        int fillIndex = 0;
        int fillValueCount = fillValues.size();
        int n = recordFunctions.size();
        for (int i = 0; i < n; ++i) {
            Function function = recordFunctions.getQuick(i);
            if (function instanceof GroupByFunction) {
                if (fillIndex == fillValueCount) {
                    throw SqlException.position(0).put("not enough values");
                }
                ExpressionNode fillNode = fillValues.getQuick(fillIndex++);
                try {
                    switch (function.getType()) {
                        case 4: {
                            placeholderFunctions.add(new IntConstant(function.getPosition(), Numbers.parseInt(fillNode.token)));
                            break;
                        }
                        case 5: {
                            placeholderFunctions.add(new LongConstant(function.getPosition(), Numbers.parseLong(fillNode.token)));
                            break;
                        }
                        case 8: {
                            placeholderFunctions.add(new FloatConstant(function.getPosition(), Numbers.parseFloat(fillNode.token)));
                            break;
                        }
                        case 9: {
                            placeholderFunctions.add(new DoubleConstant(function.getPosition(), Numbers.parseDouble(fillNode.token)));
                            break;
                        }
                        case 2: {
                            placeholderFunctions.add(new ShortConstant(function.getPosition(), (short)Numbers.parseInt(fillNode.token)));
                            break;
                        }
                        case 1: {
                            placeholderFunctions.add(new ByteConstant(function.getPosition(), (byte)Numbers.parseInt(fillNode.token)));
                            break;
                        }
                        default: {
                            throw SqlException.$(function.getPosition(), "Unsupported type: ").put(ColumnType.nameOf(function.getType()));
                        }
                    }
                    continue;
                }
                catch (NumericException e) {
                    throw SqlException.position(fillNode.position).put("invalid number: ").put(fillNode.token);
                }
            }
            placeholderFunctions.add(function);
        }
        return placeholderFunctions;
    }

    @Override
    public void close() {
        int n = this.recordFunctions.size();
        for (int i = 0; i < n; ++i) {
            this.recordFunctions.getQuick(i).close();
        }
        this.map.close();
        this.base.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        this.map.clear();
        int n = this.groupByFunctions.size();
        Record baseCursorRecord = baseCursor.getRecord();
        while (baseCursor.hasNext()) {
            MapKey key = this.map.withKey();
            this.mapSink.copy(baseCursorRecord, key);
            MapValue value = key.createValue();
            if (!value.isNew()) continue;
            value.putLong(0, Long.MIN_VALUE);
            for (int i = 0; i < n; ++i) {
                this.groupByFunctions.getQuick(i).setNull(value);
            }
        }
        if (this.map.size() == 0L) {
            baseCursor.close();
            return EmptyTableRecordCursor.INSTANCE;
        }
        baseCursor.toTop();
        boolean next = baseCursor.hasNext();
        assert (next);
        return this.initFunctionsAndCursor(executionContext, baseCursor);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @NotNull
    protected RecordCursor initFunctionsAndCursor(SqlExecutionContext executionContext, RecordCursor baseCursor) {
        this.cursor.of(baseCursor);
        int m = this.recordFunctions.size();
        for (int i = 0; i < m; ++i) {
            this.recordFunctions.getQuick(i).init(this.cursor, executionContext);
        }
        return this.cursor;
    }
}

