/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableRandomRecordCursor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.columns.TimestampColumn;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.InterpolationUtil;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.VirtualFunctionSkewedSymbolRecordCursor;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import org.jetbrains.annotations.NotNull;

public class SampleByInterpolateRecordCursorFactory
implements RecordCursorFactory {
    protected final RecordCursorFactory base;
    protected final Map recordKeyMap;
    private final Map dataMap;
    private final VirtualFunctionSkewedSymbolRecordCursor cursor;
    private final ObjList<Function> recordFunctions;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final ObjList<InterpolationUtil.StoreYFunction> storeYFunctions;
    private final ObjList<InterpolationUtil.InterpolatorFunction> interpolatorFunctions;
    private final RecordSink mapSink;
    private final RecordSink mapSink2;
    private final RecordMetadata metadata;
    private final int timestampIndex;
    private final TimestampSampler sampler;
    private final int yDataSize;
    private long yData;

    public SampleByInterpolateRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull TimestampSampler timestampSampler, @NotNull QueryModel model, @NotNull ListColumnFilter listColumnFilter, @NotNull FunctionParser functionParser, @NotNull SqlExecutionContext executionContext, @NotNull BytecodeAssembler asm, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, @NotNull EntityColumnFilter entityColumnFilter, int timestampIndex) throws SqlException {
        int i;
        int columnCount = model.getColumns().size();
        RecordMetadata metadata = base.getMetadata();
        this.groupByFunctions = new ObjList(columnCount);
        valueTypes.add(1);
        GroupByUtils.prepareGroupByFunctions(model, metadata, functionParser, executionContext, this.groupByFunctions, valueTypes);
        this.recordFunctions = new ObjList(columnCount);
        GenericRecordMetadata groupByMetadata = new GenericRecordMetadata();
        IntList symbolTableSkewIndex = GroupByUtils.prepareGroupByRecordFunctions(model, metadata, listColumnFilter, this.groupByFunctions, this.recordFunctions, groupByMetadata, keyTypes, valueTypes.getColumnCount(), false, timestampIndex);
        this.storeYFunctions = new ObjList(columnCount);
        this.interpolatorFunctions = new ObjList(columnCount);
        TimestampColumn timestampColumn = new TimestampColumn(0, valueTypes.getColumnCount() + keyTypes.getColumnCount());
        int n = this.recordFunctions.size();
        for (i = 0; i < n; ++i) {
            if (this.recordFunctions.getQuick(i) != null) continue;
            this.recordFunctions.setQuick(i, timestampColumn);
        }
        n = this.groupByFunctions.size();
        block9: for (i = 0; i < n; ++i) {
            GroupByFunction function = this.groupByFunctions.getQuick(i);
            switch (function.getType()) {
                case 1: {
                    this.storeYFunctions.add(InterpolationUtil.STORE_Y_BYTE);
                    this.interpolatorFunctions.add(InterpolationUtil.INTERPOLATE_BYTE);
                    continue block9;
                }
                case 2: {
                    this.storeYFunctions.add(InterpolationUtil.STORE_Y_SHORT);
                    this.interpolatorFunctions.add(InterpolationUtil.INTERPOLATE_SHORT);
                    continue block9;
                }
                case 4: {
                    this.storeYFunctions.add(InterpolationUtil.STORE_Y_INT);
                    this.interpolatorFunctions.add(InterpolationUtil.INTERPOLATE_INT);
                    continue block9;
                }
                case 5: {
                    this.storeYFunctions.add(InterpolationUtil.STORE_Y_LONG);
                    this.interpolatorFunctions.add(InterpolationUtil.INTERPOLATE_LONG);
                    continue block9;
                }
                case 9: {
                    this.storeYFunctions.add(InterpolationUtil.STORE_Y_DOUBLE);
                    this.interpolatorFunctions.add(InterpolationUtil.INTERPOLATE_DOUBLE);
                    continue block9;
                }
                case 8: {
                    this.storeYFunctions.add(InterpolationUtil.STORE_Y_FLOAT);
                    this.interpolatorFunctions.add(InterpolationUtil.INTERPOLATE_FLOAT);
                    continue block9;
                }
                default: {
                    Misc.freeObjList(this.groupByFunctions);
                    throw SqlException.$(function.getPosition(), "Unsupported type: ").put(ColumnType.nameOf(function.getType()));
                }
            }
        }
        this.timestampIndex = timestampIndex;
        this.yDataSize = this.groupByFunctions.size() * 16;
        this.yData = Unsafe.malloc(this.yDataSize);
        this.mapSink = RecordSinkFactory.getInstance(asm, metadata, listColumnFilter, false);
        entityColumnFilter.of(keyTypes.getColumnCount());
        this.mapSink2 = RecordSinkFactory.getInstance(asm, keyTypes, entityColumnFilter, false);
        this.recordKeyMap = MapFactory.createMap(configuration, keyTypes);
        keyTypes.add(7);
        this.dataMap = MapFactory.createMap(configuration, keyTypes, valueTypes);
        this.base = base;
        this.metadata = groupByMetadata;
        this.sampler = timestampSampler;
        this.cursor = new VirtualFunctionSkewedSymbolRecordCursor(this.recordFunctions, symbolTableSkewIndex);
    }

    @Override
    public void close() {
        int n = this.recordFunctions.size();
        for (int i = 0; i < n; ++i) {
            this.recordFunctions.getQuick(i).close();
        }
        this.recordKeyMap.close();
        this.dataMap.close();
        this.freeYData();
        this.base.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        this.recordKeyMap.clear();
        this.dataMap.clear();
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        Record baseRecord = baseCursor.getRecord();
        try {
            long sample;
            long prevSample;
            while (baseCursor.hasNext()) {
                MapKey key = this.recordKeyMap.withKey();
                this.mapSink.copy(baseRecord, key);
                key.createValue();
            }
            if (this.recordKeyMap.size() == 0L) {
                baseCursor.close();
                return EmptyTableRandomRecordCursor.INSTANCE;
            }
            baseCursor.toTop();
            boolean good = baseCursor.hasNext();
            assert (good);
            long loSample = prevSample = this.sampler.round(baseRecord.getTimestamp(this.timestampIndex));
            int n = this.groupByFunctions.size();
            do {
                int i;
                if ((sample = this.sampler.round(baseRecord.getTimestamp(this.timestampIndex))) != prevSample) {
                    this.fillGaps(prevSample, sample);
                    prevSample = sample;
                }
                MapKey key = this.dataMap.withKey();
                this.mapSink.copy(baseRecord, key);
                key.putLong(sample);
                MapValue value = key.createValue();
                if (value.isNew()) {
                    value.putByte(0, (byte)0);
                    for (i = 0; i < n; ++i) {
                        this.groupByFunctions.getQuick(i).computeFirst(value, baseRecord);
                    }
                } else {
                    for (i = 0; i < n; ++i) {
                        this.groupByFunctions.getQuick(i).computeNext(value, baseRecord);
                    }
                }
            } while (baseCursor.hasNext());
            long hiSample = this.sampler.nextTimestamp(prevSample);
            this.fillGaps(prevSample, hiSample);
            sample = prevSample = loSample;
            while (sample < hiSample) {
                RecordCursor mapCursor = this.recordKeyMap.getCursor();
                Record mapRecord = mapCursor.getRecord();
                block7: while (mapCursor.hasNext()) {
                    long x1;
                    long x2;
                    MapValue value = this.findDataMapValue(mapRecord, sample);
                    if (value.getByte(0) != 1) continue;
                    long current = sample;
                    while ((x2 = this.sampler.nextTimestamp(current)) < hiSample) {
                        value = this.findDataMapValue(mapRecord, x2);
                        if (value.getByte(0) == 1) {
                            current = x2;
                            continue;
                        }
                        if (sample == loSample) {
                            x1 = x2;
                            while ((x2 = this.sampler.nextTimestamp(x2)) < hiSample) {
                                MapValue x2value = this.findDataMapValue(mapRecord, x2);
                                if (x2value.getByte(0) != 0) continue;
                                this.computeYPoints(mapRecord, x1, x2value);
                                this.interpolateRange(x1, x2, loSample, x1, mapRecord);
                                continue block7;
                            }
                            this.nullifyRange(loSample, x1, mapRecord);
                            this.nullifyRange(this.sampler.nextTimestamp(x1), hiSample, mapRecord);
                            continue block7;
                        }
                        this.computeYPoints(mapRecord, prevSample, value);
                        this.interpolateRange(prevSample, x2, this.sampler.nextTimestamp(prevSample), x2, mapRecord);
                        continue block7;
                    }
                    x1 = this.sampler.previousTimestamp(prevSample);
                    if (x1 < loSample) {
                        this.nullifyRange(sample, hiSample, mapRecord);
                        continue;
                    }
                    this.computeYPoints(mapRecord, x1, this.findDataMapValue(mapRecord, prevSample));
                    this.interpolateRange(x1, prevSample, this.sampler.nextTimestamp(prevSample), hiSample, mapRecord);
                }
                prevSample = sample;
                sample = this.sampler.nextTimestamp(sample);
            }
            return this.initFunctionsAndCursor(executionContext, this.dataMap.getCursor(), baseCursor);
        }
        catch (CairoException e) {
            baseCursor.close();
            throw e;
        }
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    private void computeYPoints(Record record, long x1, MapValue x2value) {
        int m = this.groupByFunctions.size();
        for (int i = 0; i < m; ++i) {
            this.storeYFunctions.getQuick(i).store(this.groupByFunctions.getQuick(i), x2value, this.yData + (long)(i * 16) + 8L);
        }
        MapValue x1value = this.findDataMapValue(record, x1);
        int m2 = this.groupByFunctions.size();
        for (int i = 0; i < m2; ++i) {
            this.storeYFunctions.getQuick(i).store(this.groupByFunctions.getQuick(i), x1value, this.yData + (long)(i * 16));
        }
    }

    private void fillGaps(long lo, long hi) {
        RecordCursor keyCursor = this.recordKeyMap.getCursor();
        Record record = keyCursor.getRecord();
        long timestamp = lo;
        while (timestamp < hi) {
            while (keyCursor.hasNext()) {
                MapKey key = this.dataMap.withKey();
                this.mapSink2.copy(record, key);
                key.putLong(timestamp);
                MapValue value = key.createValue();
                if (!value.isNew()) continue;
                value.putByte(0, (byte)1);
            }
            timestamp = this.sampler.nextTimestamp(timestamp);
            keyCursor.toTop();
        }
    }

    private MapValue findDataMapValue(Record record, long timestamp) {
        MapKey key = this.dataMap.withKey();
        this.mapSink2.copy(record, key);
        key.putLong(timestamp);
        return key.findValue();
    }

    private void freeYData() {
        if (this.yData != 0L) {
            Unsafe.free(this.yData, this.yDataSize);
            this.yData = 0L;
        }
    }

    @NotNull
    protected RecordCursor initFunctionsAndCursor(SqlExecutionContext executionContext, RecordCursor mapCursor, RecordCursor baseCursor) {
        this.cursor.of(baseCursor, mapCursor);
        int m = this.recordFunctions.size();
        for (int i = 0; i < m; ++i) {
            this.recordFunctions.getQuick(i).init(this.cursor, executionContext);
        }
        return this.cursor;
    }

    private void interpolateRange(long x1, long x2, long lo, long hi, Record record) {
        long x = lo;
        while (x < hi) {
            MapKey key = this.dataMap.withKey();
            this.mapSink2.copy(record, key);
            key.putLong(x);
            MapValue value = key.findValue();
            assert (value != null && value.getByte(0) == 1);
            value.putByte(0, (byte)0);
            int m = this.groupByFunctions.size();
            for (int i = 0; i < m; ++i) {
                this.interpolatorFunctions.getQuick(i).interpolateAndStore(this.groupByFunctions.getQuick(i), value, x, x1, x2, this.yData + (long)(i * 16), this.yData + (long)(i * 16) + 8L);
            }
            x = this.sampler.nextTimestamp(x);
        }
    }

    private void nullifyRange(long lo, long hi, Record record) {
        long x = lo;
        while (x < hi) {
            MapKey key = this.dataMap.withKey();
            this.mapSink2.copy(record, key);
            key.putLong(x);
            MapValue value = key.findValue();
            assert (value != null && value.getByte(0) == 1);
            value.putByte(0, (byte)0);
            int m = this.groupByFunctions.size();
            for (int i = 0; i < m; ++i) {
                this.groupByFunctions.getQuick(i).setNull(value);
            }
            x = this.sampler.nextTimestamp(x);
        }
    }
}

