/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.std.BinarySequence;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class SplitVirtualRecord
implements Record {
    private final ObjList<? extends Function> functionsA;
    private final ObjList<? extends Function> functionsB;
    private ObjList<? extends Function> current;
    private Record base;

    public SplitVirtualRecord(ObjList<? extends Function> functionsA, ObjList<? extends Function> functionsB) {
        this.functionsA = functionsA;
        this.functionsB = functionsB;
    }

    @Override
    public BinarySequence getBin(int col) {
        return this.getFunction(col).getBin(this.base);
    }

    @Override
    public long getBinLen(int col) {
        BinarySequence sequence = this.getBin(col);
        if (sequence == null) {
            return -1L;
        }
        return sequence.length();
    }

    @Override
    public boolean getBool(int col) {
        return this.getFunction(col).getBool(this.base);
    }

    @Override
    public byte getByte(int col) {
        return this.getFunction(col).getByte(this.base);
    }

    @Override
    public long getDate(int col) {
        return this.getFunction(col).getDate(this.base);
    }

    @Override
    public double getDouble(int col) {
        return this.getFunction(col).getDouble(this.base);
    }

    @Override
    public float getFloat(int col) {
        return this.getFunction(col).getFloat(this.base);
    }

    @Override
    public int getInt(int col) {
        return this.getFunction(col).getInt(this.base);
    }

    @Override
    public long getLong(int col) {
        return this.getFunction(col).getLong(this.base);
    }

    @Override
    public long getRowId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(int col) {
        return this.getFunction(col).getShort(this.base);
    }

    @Override
    public char getChar(int col) {
        return this.getFunction(col).getChar(this.base);
    }

    @Override
    public CharSequence getStr(int col) {
        return this.getFunction(col).getStr(this.base);
    }

    @Override
    public void getStr(int col, CharSink sink) {
        this.getFunction(col).getStr(this.base, sink);
    }

    @Override
    public CharSequence getStrB(int col) {
        return this.getFunction(col).getStrB(this.base);
    }

    @Override
    public int getStrLen(int col) {
        return this.getFunction(col).getStrLen(this.base);
    }

    @Override
    public CharSequence getSym(int col) {
        return this.getFunction(col).getSymbol(this.base);
    }

    @Override
    public long getTimestamp(int col) {
        return this.getFunction(col).getTimestamp(this.base);
    }

    public void of(Record record) {
        this.base = record;
    }

    public void setActiveA() {
        if (this.current != this.functionsA) {
            this.current = this.functionsA;
        }
    }

    public void setActiveB() {
        if (this.current != this.functionsB) {
            this.current = this.functionsB;
        }
    }

    private Function getFunction(int columnIndex) {
        return this.current.getQuick(columnIndex);
    }
}

