/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.groupby.MicroTimestampSampler;
import io.questdb.griffin.engine.groupby.MonthTimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.YearTimestampSampler;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;

public final class TimestampSamplerFactory {
    public static TimestampSampler getInstance(CharSequence cs, int position) throws SqlException {
        int k;
        block17: {
            k = -1;
            if (cs == null) {
                throw SqlException.$(position, "missing interval");
            }
            int len = cs.length();
            for (int i = 0; i < len; ++i) {
                char c = cs.charAt(i);
                if (c >= '0' && c <= '9') continue;
                k = i;
                break;
            }
            if (k == -1) {
                throw SqlException.$(position + len, "expected interval qualifier");
            }
            if (k + 1 < len) {
                throw SqlException.$(position + k, "expected single letter qualifier");
            }
            try {
                int n;
                if (k == 0) {
                    n = 1;
                } else {
                    n = Numbers.parseInt(cs, 0, k);
                    if (n == 0) {
                        throw SqlException.$(position, "zero is not a valid sample value");
                    }
                }
                switch (cs.charAt(k)) {
                    case 's': {
                        return new MicroTimestampSampler(1000000L * (long)n);
                    }
                    case 'm': {
                        return new MicroTimestampSampler(60000000L * (long)n);
                    }
                    case 'h': {
                        return new MicroTimestampSampler(3600000000L * (long)n);
                    }
                    case 'd': {
                        return new MicroTimestampSampler(86400000000L * (long)n);
                    }
                    case 'M': {
                        return new MonthTimestampSampler(n);
                    }
                    case 'y': {
                        return new YearTimestampSampler(n);
                    }
                }
            }
            catch (NumericException ignore) {
                if ($assertionsDisabled) break block17;
                throw new AssertionError();
            }
        }
        throw SqlException.$(position + k, "unsupported interval qualifier");
    }
}

