/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.microtime.Timestamps;

class YearTimestampSampler
implements TimestampSampler {
    private final int bucket;

    public YearTimestampSampler(int bucket) {
        this.bucket = bucket;
    }

    @Override
    public long nextTimestamp(long timestamp) {
        return Timestamps.addYear(timestamp, this.bucket);
    }

    @Override
    public long previousTimestamp(long timestamp) {
        return Timestamps.addYear(timestamp, -this.bucket);
    }

    @Override
    public long round(long value) {
        int y = Timestamps.getYear(value);
        y -= y % this.bucket;
        return Timestamps.yearMicros(y, Timestamps.isLeapYear(y));
    }
}

