/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class AvgLongVectorAggregateFunction
extends DoubleFunction
implements VectorAggregateFunction {
    private final DoubleAdder sum = new DoubleAdder();
    private final LongAdder count = new LongAdder();
    private final int columnIndex;

    public AvgLongVectorAggregateFunction(int position, int columnIndex) {
        super(position);
        this.columnIndex = columnIndex;
    }

    @Override
    public void aggregate(long address, long count) {
        double value;
        if (address != 0L && (value = Vect.avgLong(address, count)) == value) {
            this.sum.add(value);
            this.count.increment();
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public void clear() {
        this.sum.reset();
        this.count.reset();
    }

    @Override
    public double getDouble(Record rec) {
        long count = this.count.sum();
        if (count > 0L) {
            return this.sum.sum() / (double)count;
        }
        return Double.NaN;
    }
}

