/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.MessageBus;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateEntry;
import io.questdb.mp.Job;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.tasks.VectorAggregateTask;

public class GroupByNotKeyedJob
implements Job {
    private final RingQueue<VectorAggregateTask> queue;
    private final Sequence subSeq;

    public GroupByNotKeyedJob(MessageBus messageBus) {
        this.queue = messageBus.getVectorAggregateQueue();
        this.subSeq = messageBus.getVectorAggregateSubSequence();
    }

    @Override
    public boolean run() {
        long cursor;
        do {
            if ((cursor = this.subSeq.next()) != -1L) continue;
            return false;
        } while (cursor == -2L);
        VectorAggregateTask queueItem = this.queue.get(cursor);
        VectorAggregateEntry entry = queueItem.entry;
        this.subSeq.done(cursor);
        return entry.run();
    }
}

