/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.function.DoubleBinaryOperator;

public class MaxDoubleVectorAggregateFunction
extends DoubleFunction
implements VectorAggregateFunction {
    public static final DoubleBinaryOperator MAX = Math::max;
    private final DoubleAccumulator max = new DoubleAccumulator(MAX, Double.NEGATIVE_INFINITY);
    private final int columnIndex;

    public MaxDoubleVectorAggregateFunction(int position, int columnIndex) {
        super(position);
        this.columnIndex = columnIndex;
    }

    @Override
    public void aggregate(long address, long count) {
        double value;
        if (address != 0L && (value = Vect.maxDouble(address, count)) == value) {
            this.max.accumulate(value);
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public void clear() {
        this.max.reset();
    }

    @Override
    public double getDouble(Record rec) {
        double value = this.max.get();
        return Double.isInfinite(value) ? Double.NaN : value;
    }
}

