/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.LongBinaryOperator;

public class MaxIntVectorAggregateFunction
extends IntFunction
implements VectorAggregateFunction {
    public static final LongBinaryOperator MAX = Math::max;
    private final LongAccumulator max = new LongAccumulator(MAX, Integer.MIN_VALUE);
    private final int columnIndex;

    public MaxIntVectorAggregateFunction(int position, int columnIndex) {
        super(position);
        this.columnIndex = columnIndex;
    }

    @Override
    public void aggregate(long address, long count) {
        if (address != 0L) {
            this.max.accumulate(Vect.maxInt(address, count));
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public void clear() {
        this.max.reset();
    }

    @Override
    public int getInt(Record rec) {
        return this.max.intValue();
    }
}

