/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.function.DoubleBinaryOperator;

public class MinDoubleVectorAggregateFunction
extends DoubleFunction
implements VectorAggregateFunction {
    public static final DoubleBinaryOperator MIN = Math::min;
    private final DoubleAccumulator min = new DoubleAccumulator(MIN, Double.POSITIVE_INFINITY);
    private final int columnIndex;

    public MinDoubleVectorAggregateFunction(int position, int columnIndex) {
        super(position);
        this.columnIndex = columnIndex;
    }

    @Override
    public void aggregate(long address, long count) {
        double value;
        if (address != 0L && (value = Vect.minDouble(address, count)) == value) {
            this.min.accumulate(value);
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public void clear() {
        this.min.reset();
    }

    @Override
    public double getDouble(Record rec) {
        double min = this.min.get();
        if (Double.isInfinite(min)) {
            return Double.NaN;
        }
        return min;
    }
}

