/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.LongBinaryOperator;

public class MinIntVectorAggregateFunction
extends IntFunction
implements VectorAggregateFunction {
    public static final LongBinaryOperator MIN = Math::min;
    private final LongAccumulator accumulator = new LongAccumulator(MIN, Integer.MAX_VALUE);
    private final int columnIndex;

    public MinIntVectorAggregateFunction(int position, int columnIndex) {
        super(position);
        this.columnIndex = columnIndex;
    }

    @Override
    public void aggregate(long address, long count) {
        int value;
        if (address != 0L && (value = Vect.minInt(address, count)) != Integer.MIN_VALUE) {
            this.accumulator.accumulate(value);
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public void clear() {
        this.accumulator.reset();
    }

    @Override
    public int getInt(Record rec) {
        int value = this.accumulator.intValue();
        return value == Integer.MAX_VALUE ? Integer.MIN_VALUE : value;
    }
}

