/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.LongBinaryOperator;

public class MinLongVectorAggregateFunction
extends LongFunction
implements VectorAggregateFunction {
    public static final LongBinaryOperator MIN = Math::min;
    private final LongAccumulator accumulator = new LongAccumulator(MIN, Long.MAX_VALUE);
    private final int columnIndex;

    public MinLongVectorAggregateFunction(int position, int columnIndex) {
        super(position);
        this.columnIndex = columnIndex;
    }

    @Override
    public void aggregate(long address, long count) {
        long value;
        if (address != 0L && (value = Vect.minLong(address, count)) != Long.MIN_VALUE) {
            this.accumulator.accumulate(value);
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public void clear() {
        this.accumulator.reset();
    }

    @Override
    public long getLong(Record rec) {
        long value = this.accumulator.longValue();
        return value == Long.MAX_VALUE ? Long.MIN_VALUE : value;
    }
}

