/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.LongAdder;

public class SumLongVectorAggregateFunction
extends LongFunction
implements VectorAggregateFunction {
    private final LongAdder sum = new LongAdder();
    private final LongAdder count = new LongAdder();
    private final int columnIndex;

    public SumLongVectorAggregateFunction(int position, int columnIndex) {
        super(position);
        this.columnIndex = columnIndex;
    }

    @Override
    public void aggregate(long address, long count) {
        long value;
        if (address != 0L && (value = Vect.sumLong(address, count)) != Long.MIN_VALUE) {
            this.sum.add(value);
            this.count.increment();
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public void clear() {
        this.sum.reset();
        this.count.reset();
    }

    @Override
    public long getLong(Record rec) {
        if (this.count.sum() > 0L) {
            return this.sum.sum();
        }
        return Long.MIN_VALUE;
    }
}

