/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.mp.CountDownLatchSPI;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;

public class VectorAggregateEntry
implements Mutable {
    private static final long TARGET_SEQUENCE_OFFSET = Unsafe.getFieldOffset(VectorAggregateEntry.class, "targetSequence");
    private long address;
    private long count;
    private VectorAggregateFunction func;
    private int srcSequence;
    private int targetSequence;
    private CountDownLatchSPI doneLatch;

    void of(int counter, VectorAggregateFunction vaf, long pageAddress, long pageValueCount, CountDownLatchSPI doneLatch) {
        this.address = pageAddress;
        this.count = pageValueCount;
        this.func = vaf;
        this.srcSequence = counter;
        this.targetSequence = counter;
        this.doneLatch = doneLatch;
    }

    public boolean tryLock() {
        return Unsafe.cas((Object)this, TARGET_SEQUENCE_OFFSET, this.srcSequence, this.srcSequence + 1);
    }

    public boolean run() {
        if (this.tryLock()) {
            this.func.aggregate(this.address, this.count);
            this.doneLatch.countDown();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.address = 0L;
        this.count = 0L;
        this.func = null;
    }
}

