/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordChain;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.HashOuterJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.std.Misc;

public class HashJoinRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final Map joinKeyMap;
    private final RecordChain slaveChain;
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink masterSink;
    private final RecordSink slaveKeySink;
    private final HashJoinRecordCursor cursor;

    public HashJoinRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterSink, RecordSink slaveKeySink, RecordSink slaveChainSink, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.joinKeyMap = MapFactory.createMap(configuration, joinColumnTypes, valueTypes);
        this.slaveChain = new RecordChain(slaveFactory.getMetadata(), slaveChainSink, configuration.getSqlHashJoinValuePageSize());
        this.masterSink = masterSink;
        this.slaveKeySink = slaveKeySink;
        this.cursor = new HashJoinRecordCursor(columnSplit, this.joinKeyMap, this.slaveChain);
    }

    @Override
    public void close() {
        this.joinKeyMap.close();
        this.slaveChain.close();
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        try {
            this.buildMapOfSlaveRecords(slaveCursor);
        }
        catch (CairoException e) {
            slaveCursor.close();
            throw e;
        }
        this.cursor.of(this.masterFactory.getCursor(executionContext), slaveCursor);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    private void buildMapOfSlaveRecords(RecordCursor slaveCursor) {
        HashOuterJoinRecordCursorFactory.buildMap(slaveCursor, slaveCursor.getRecord(), this.joinKeyMap, this.slaveKeySink, this.slaveChain);
    }

    private class HashJoinRecordCursor
    implements NoRandomAccessRecordCursor {
        private final JoinRecord recordA;
        private final RecordChain slaveChain;
        private final Map joinKeyMap;
        private final int columnSplit;
        private RecordCursor masterCursor;
        private RecordCursor slaveCursor;
        private Record masterRecord;
        private boolean useSlaveCursor;

        public HashJoinRecordCursor(int columnSplit, Map joinKeyMap, RecordChain slaveChain) {
            this.recordA = new JoinRecord(columnSplit);
            this.joinKeyMap = joinKeyMap;
            this.slaveChain = slaveChain;
            this.columnSplit = columnSplit;
        }

        @Override
        public void close() {
            this.masterCursor = Misc.free(this.masterCursor);
            this.slaveCursor = Misc.free(this.slaveCursor);
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            if (columnIndex < this.columnSplit) {
                return this.masterCursor.getSymbolTable(columnIndex);
            }
            return this.slaveCursor.getSymbolTable(columnIndex - this.columnSplit);
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public boolean hasNext() {
            if (this.useSlaveCursor && this.slaveChain.hasNext()) {
                return true;
            }
            while (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashJoinRecordCursorFactory.this.masterSink);
                MapValue value = key.findValue();
                if (value == null) continue;
                this.slaveChain.of(value.getLong(0));
                this.slaveChain.hasNext();
                this.useSlaveCursor = true;
                return true;
            }
            return false;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.useSlaveCursor = false;
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.masterRecord = masterCursor.getRecord();
            Record slaveRecord = this.slaveChain.getRecord();
            this.slaveChain.setSymbolTableResolver(slaveCursor);
            this.recordA.of(this.masterRecord, slaveRecord);
            this.useSlaveCursor = false;
        }
    }
}

